#include <stdio.h>
#include <stdlib.h>

typedef struct line {
    double a, b, c;
} LINE;

typedef struct pointin2d {
    double x, y;
} POINT;

typedef struct circle {
    POINT c;
    double r;
} CIRC;

typedef struct arc {
    POINT c;
    double r, as, ae;
} ARC;

void READ(POINT *p)
{
    scanf("%lf%lf", &p->x, &p->y);
    return;
}

void READ(LINE *l)
{
    scanf("%lf%lf%lf", &l->a, &l->b, &l->c);
    return;
}

void READ(CIRC *c)
{
    scanf("%lf%lf%lf", &(c->c).x, &(c->c).y, &c->r);
    return;
}

void WRITE(CIRC c)
{
    printf("circle %f %f %f\n", c.c.x, c.c.y, c.r);
    return;
}

void WRITE(LINE l)
{
    printf("line %f %f %f\n", l.a, l.b, l.c);
    return;
}

// ３点を頂点とする三角形を描く
void WRITE(POINT p, POINT q, POINT r)
{
    printf("connect %f %f %f %f %f %f %f %f\n", p.x, p.y, q.x, q.y, r.x, r.y, p.x, p.y);
    return;
}

// ２点を結ぶ線分を描く
void WRITE(POINT p, POINT q)
{
    printf("connect %f %f %f %f\n", p.x, p.y, q.x, q.y);
    return;
}

void WRITE(POINT p)
{
    printf("disk %f %f .05\n", p.x, p.y);
}

void WRITE(ARC a)
{
	double t;

	t = 180 * 64 * a.as / M_PI;
    printf("circle %f %f %f %f %f\n", a.c.x, a.c.y, a.r, t, 180 * 64 * a.ae / M_PI - t);
    return;
}

// ２点を結ぶ線分の垂直二等分線
LINE operator |(POINT p, POINT q)
{
    POINT midpt;
    LINE l;

    midpt.x = (p.x + q.x) / 2.;
    midpt.y = (p.y + q.y) / 2.;
    l.a = p.x - q. x;
    l.b = p.y - q.y;
    l.c = -l.a * midpt.x - l.b * midpt.y;
    return l;
}

// 点から直線への垂線
LINE operator |(POINT p, LINE l)
{
    LINE m;

    m.a = l.b; m.b = -l.a;
    m.c = -m.a * p.x - m.b * p.y;
    return m;
}

LINE operator /(POINT p, LINE l)
{
    LINE m;

    m.a = l.a; m.b = l.b;
    m.c = -m.a * p.x - m.b * p.y;
    return m;
}

// ２点を結ぶ線分の中点
POINT operator %(POINT p, POINT q)
{
    POINT midpt;

    midpt.x = (p.x + q.x) / 2.;
    midpt.y = (p.y + q.y) / 2.;
    return midpt;
}

// ２直線の交点
POINT operator *(LINE l1, LINE l2)
{
    double d;
    POINT p;

    if((d = l1.a * l2.b - l1.b * l2.a) == 0.) {
	fprintf(stderr, "Error\n");
	exit(0);
    }
    p.x = (l2.c * l1.b - l1.c * l2.b) / d;
    p.y = (l2.a * l1.c - l1.a * l2.c) / d;
    return p;
}

// ２点を結ぶ直線
LINE operator *(POINT p, POINT q)
{
    LINE l;

    l.a = p.y - q.y;
    l.b = q.x - p.x;
    l.c = -l.a * p.x - l.b * p.y;
    return l;
}

