#include "cmconst.h"

int getpoly(int md, double c[], char *s)
{
    int i, x, y, d, dd = 0;
    char *s0, cs, xoy;
    double f, w = 0;

    for(i = 0; i < MNN; i++) c[i] = 0.;
    for(; *s != 0; ) {
	x = y = 0; f = 1.;
	if(*s == '+') s++;
	if(*s == '-') {
	    f = -1.;
	    s++;
	}
	for(s0 = s; ; s++) if((*s > '9' || *s < '0') && *s != '.') break;
	if((*s != 'x') && (*s != 'y') && (*s != 0) && (*s != '+') && (*s != '-')) return -1;
	if(s0 == s) w = 1.;
	else {
	    cs = *s; *s = 0;
	    w = atof(s0);
	    *s = cs;
	}
	if(((xoy = *s) == 'x') || (xoy == 'y')) {
	    s++;
	    if(*s == '^') s++;
	    for(s0 = s; ; s++) if(*s > '9' || *s < '0') break;
	    if(s0 == s) {
		if(xoy == 'x') x = 1;
		else y = 1;
	    }
	    else {
		cs = *s; *s = 0;
		if(xoy == 'x') x = atoi(s0);
		else y = atoi(s0);
		*s = cs;
	    }
	}
	if(((xoy = *s) == 'x') || (xoy == 'y')) {
	    s++;
	    if(*s == '^') s++;
	    for(s0 = s; ; s++) if(*s > '9' || *s < '0') break;
	    if(s0 == s) {
		if(xoy == 'x') x = 1;
		else y = 1;
	    }
	    else {
		cs = *s; *s = 0;
		if(xoy == 'x') x = atoi(s0);
		else y = atoi(s0);
		*s = cs;
	    }
	}
	if((d = x + y) > md) return 0;
	if(d > dd) dd = d;
	c[d * (d + 1) / 2 + x] += f * w;
    }
    return dd;
}

void mlpoly(int md1, double c1[], int md2, double c2[])
{
    int i, j, k, x1, x2, d1, d2, d, md;
    double c3[MNN];

    d = md1 + md2;
    md = (d + 1) * (d + 2) / 2;
    for(i = 0; i < md; i++) c3[i] = 0.;
    for(d1 = x1 = i = 0; ; x1++, i++) {
	if(x1 > d1) {
	    d1++;
	    if(d1 > md1) break;
	    x1 = 0;
	}
	k = i;
	for(d2 = x2 = j = 0; ; x2++, j++) {
	    if(x2 > d2) {
		d2++;
		if(d2 > md2) break;
		x2 = 0;
		k += d1;
	    }
	    c3[k++] += c1[i] * c2[j];
	}
    }
    for(i = 0; i < md; i++) c1[i] = c3[i];
}

void pwofpoly(int d, double c[], int n)
{
    int i, md, d2 = d;
    double c2[MNN];

    md = (d + 1) * (d + 2) / 2;
    for(i = 0; i < md; i++) c2[i] = c[i];
    for(i = 1; i < n; i++, d2 += d) mlpoly(d2, c, d, c2);
}

void addpoly(int md1, double c1[], int md2, double c2[])
{
    int i, md;

    md = (md2 + 1) * (md2 + 2) / 2;
    for(i = 0; i < md; i++) c1[i] += c2[i];
}

int expand(char *s, double c[])
{
    int i, j, ocn, f = 0, d = 0, d1, d2;
    char str[MXSTRLH], *ps, *ps0, *ps2;
    double c1[MNN], c2[MNN];

    for(i = 0; i < MNN; i++) c[i] = 0.;
    for(ps = ps0 = str; *s != '\0'; ) {
	if(*s == '(') {
	    if(f == 0) {
		if(ps > ps0) {
		    for(ps2 = ps - 1; ps2 >= ps0; ps2--) if((*ps2 == '+') || (*ps2 == '-')) break;
		    if(ps2 > ps0) {
			*ps2 = '\0';
			d1 = getpoly(MAXD, c1, str);
			addpoly(d, c, d1, c1);
			if(d1 > d) d = d1;
			ps0 = ps2;
		    }
		    if(ps > ps2 + 1) {
			if(ps2 < ps0) ps2 = ps0;
			for(j = ps - ps2, i = 0; j > 0; j--) str[i++] = *(s - j);
			//		for(ps2 = ps0, i = 0; ps2 < ps; ps2++) str[i++] = *(s + ps2 - ps);
			str[i] = '\0';
			d1 = getpoly(MAXD, c1, str);
		    }
		    else {
			d1 = 0;
			if(*(s - 1) == '-') c1[0] = -1.;
			else c1[0] = 1.;
		    }
		}
		else {
		    d1 = 0;
		    c1[0] = 1.;
		}
		f = 1;
	    }
	    for(s++, i = ocn = 0; *s != '\0'; s++) {
		if(*s == '(') ocn++;
		else if(*s == ')') {
		    ocn--;
		    if(ocn < 0) break;
		}
		str[i++] = *s;
	    }
	    str[i] = '\0';
	    d2 = expand(str, c2);
	    ps = str;
	    if(*s == '\0') break;
	    s++;
	    if(*s == '^') s++;
	    for(s; (*s >= '0') && (*s <= '9'); s++) *(ps++) = *s;
	    if(ps > str) {
		int n;

		*ps = '\0';
		n = atoi(str);
		pwofpoly(d2, c2, n);
		d2 *= n;
	    }
	    mlpoly(d1, c1, d2, c2);
	    d1 += d2;
	    ps0 = ps = str;
	}
	else {
	    if(f == 1) {
		addpoly(d, c, d1, c1);
		if(d1 > d) d = d1;
		f = 0;
	    }
	    *(ps++) = *(s++);
	}
    }
    if(f == 1) {
	addpoly(d, c, d1, c1);
	if(d1 > d) d = d1;
    }
    else if(ps > str) {
	*ps = '\0';
	d1 = getpoly(MAXD, c1, str);
	addpoly(d, c, d1, c1);
	if(d1 > d) d = d1;
    }
    return d;
}

int checkeq(char *s)
{
    int ocb = 0;

    for(; *s != '\0'; s++) {
	if((*s >= '0') && (*s <= '9')) continue;
	if((*s == 'x') || (*s == 'y') || (*s == '.') || (*s == '+') || (*s == '-') || (*s == '^')) continue;
	if(*s == '(') ocb++;
	else if(*s == ')') {
	    ocb--;
	    if(ocb < 0) return -1;
	}
	else return -1;
    }
    if(ocb > 0) return -1;
    else return 1;
}
