#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include "cmconst.h"
#include <math.h>

#define NUMOFBUTTON 1
#define END 0
#define EXEC 1
#define BUTTON_WIDTH 50
#define BUTTON_HEIGHT 26
#define DRAW_BLACK 1
#define DRAW_WHITE 2
#define NOFC 64
#define CSTEP 16384
#define NUMOFCMDS 23
#define NUMOFSCN 3
#define HAK_WIDTH 140
#define HAK_HEIGHT 26

Display *display;
char *button_name[] = {"End"}, *hak_st = "Hit any key";
Window top;
Window buttons[NUMOFBUTTON], hakw;
GC buttonGC, hakGC;
Font font;
Window canvas;
GC canvasGC;
Pixmap pixmap[NUMOFSCN];
GC pmGC;
GC clearGC;
int commandX, commandY, path;
Colormap cmap;
XColor color[NOFC + 101];
XPoint points[MNP];
char *grcmds[]={"color", "point", "line", "ellipse", "polygon", "curve", "circle", "stop", "sleep", "copy", "connect", "active", "display", "clear", "text", "disk", "Disk", "pause", "Text", "gray", "flush", "tsleep", "end", 0};
char sleep_str[20];
int ox, oy, TOP_WIDTH, TOP_HEIGHT, CANVAS_WIDTH, CANVAS_HEIGHT, adp, ddp;
double scale;

double c[MNN], x[(MAXD + 1) * MAXD], z[MAXD];
int cut(char s[], int a[]);
int getl(char *s);

int cmpword(char *s1, char *s2)
{
    for(;;){
        if(*s1 > *s2) return 1;
        else if(*s1 < *s2) return -1;
        if(*(s1++) == '\0') break;
        s2++;
    }
    return 0;
}

int getpoly(int md, double c[], char *s)
{
    int i, x, y, d, dd = 0;
    char *s0, cs, xoy;
    double f, w = 0;

    for(i = 0; i < MNN; i++) c[i] = 0.;
    for(; *s != 0; ) {
		x = y = 0; f = 1.;
		if(*s == '+') s++;
		if(*s == '-') {
			f = -1.;
			s++;
		}
		for(s0 = s; ; s++) if((*s > '9' || *s < '0') && *s != '.') break;
		if((*s != 'x') && (*s != 'y') && (*s != 0) && (*s != '+') && (*s != '-')) return -1;
		if(s0 == s) w = 1.;
		else {
			cs = *s; *s = 0;
			w = atof(s0);
			*s = cs;
		}
		if(((xoy = *s) == 'x') || (xoy == 'y')) {
			s++;
			if(*s == '^') s++;
			for(s0 = s; ; s++) if(*s > '9' || *s < '0') break;
			if(s0 == s) {
				if(xoy == 'x') x = 1;
				else y = 1;
			}
			else {
				cs = *s; *s = 0;
				if(xoy == 'x') x = atoi(s0);
				else y = atoi(s0);
				*s = cs;
			}
		}
		if(((xoy = *s) == 'x') || (xoy == 'y')) {
			s++;
			if(*s == '^') s++;
			for(s0 = s; ; s++) if(*s > '9' || *s < '0') break;
			if(s0 == s) {
				if(xoy == 'x') x = 1;
				else y = 1;
			}
			else {
				cs = *s; *s = 0;
				if(xoy == 'x') x = atoi(s0);
				else y = atoi(s0);
				*s = cs;
			}
		}
		if((d = x + y) > md) return 0;
		if(d > dd) dd = d;
		c[d * (d + 1) / 2 + x] += f * w;
    }
    return dd;
}

void mlpoly(int md1, double c1[], int md2, double c2[])
{
    int i, j, k, x1, x2, d1, d2, d, md;
    double c3[MNN];

    d = md1 + md2;
    md = (d + 1) * (d + 2) / 2;
    for(i = 0; i < md; i++) c3[i] = 0.;
    for(d1 = x1 = i = 0; ; x1++, i++) {
		if(x1 > d1) {
			d1++;
			if(d1 > md1) break;
			x1 = 0;
		}
		k = i;
		for(d2 = x2 = j = 0; ; x2++, j++) {
			if(x2 > d2) {
				d2++;
				if(d2 > md2) break;
				x2 = 0;
				k += d1;
			}
			c3[k++] += c1[i] * c2[j];
		}
    }
    for(i = 0; i < md; i++) c1[i] = c3[i];
}

void pwofpoly(int d, double c[], int n)
{
    int i, md, d2 = d;
    double c2[MNN];

    md = (d + 1) * (d + 2) / 2;
    for(i = 0; i < md; i++) c2[i] = c[i];
    for(i = 1; i < n; i++, d2 += d) mlpoly(d2, c, d, c2);
}

void addpoly(int md1, double c1[], int md2, double c2[])
{
    int i, md;

    md = (md2 + 1) * (md2 + 2) / 2;
    for(i = 0; i < md; i++) c1[i] += c2[i];
}

int expand(char *s, double c[])
{
    int i, j, ocn, f = 0, d = 0, d1, d2;
    char str[256], *ps, *ps0, *ps2;
    double c1[MNN], c2[MNN];

    for(i = 0; i < MNN; i++) c[i] = 0.;
    for(ps = ps0 = str; *s != '\0'; ) {
		if(*s == '(') {
			if(f == 0) {
				if(ps > ps0) {
					for(ps2 = ps - 1; ps2 >= ps0; ps2--) if((*ps2 == '+') || (*ps2 == '-')) break;
					if(ps2 > ps0) {
						*ps2 = '\0';
						d1 = getpoly(MAXD, c1, str);
						addpoly(d, c, d1, c1);
						if(d1 > d) d = d1;
						ps0 = ps2;
					}
					if(ps > ps2 + 1) {
						if(ps2 < ps0) ps2 = ps0;
						for(j = ps - ps2, i = 0; j > 0; j--) str[i++] = *(s - j);
			//		for(ps2 = ps0, i = 0; ps2 < ps; ps2++) str[i++] = *(s + ps2 - ps);
						str[i] = '\0';
						d1 = getpoly(MAXD, c1, str);
					}
					else {
						d1 = 0;
						if(*(s - 1) == '-') c1[0] = -1.;
						else c1[0] = 1.;
					}
				}
				else {
					d1 = 0;
					c1[0] = 1.;
				}
				f = 1;
			}
			for(s++, i = ocn = 0; *s != '\0'; s++) {
				if(*s == '(') ocn++;
				else if(*s == ')') {
					ocn--;
					if(ocn < 0) break;
				}
				str[i++] = *s;
			}
			str[i] = '\0';
			d2 = expand(str, c2);
			ps = str;
			if(*s == '\0') break;
			s++;
			if(*s == '^') s++;
			for(s; (*s >= '0') && (*s <= '9'); s++) *(ps++) = *s;
			if(ps > str) {
				int n;

				*ps = '\0';
				n = atoi(str);
				pwofpoly(d2, c2, n);
				d2 *= n;
			}
			mlpoly(d1, c1, d2, c2);
			d1 += d2;
			ps0 = ps = str;
		}
		else {
			if(f == 1) {
				addpoly(d, c, d1, c1);
				if(d1 > d) d = d1;
				f = 0;
			}
			*(ps++) = *(s++);
		}
    }
    if(f == 1) {
		addpoly(d, c, d1, c1);
		if(d1 > d) d = d1;
    }
    else if(ps > str) {
		*ps = '\0';
		d1 = getpoly(MAXD, c1, str);
		addpoly(d, c, d1, c1);
		if(d1 > d) d = d1;
    }
    return d;
}

int checkeq(char *s)
{
    int ocb = 0;

    for(; *s != '\0'; s++) {
		if((*s >= '0') && (*s <= '9')) continue;
		if((*s == 'x') || (*s == 'y') || (*s == '.') || (*s == '+') || (*s == '-') || (*s == '^')) continue;
		if(*s == '(') ocb++;
		else if(*s == ')') {
			ocb--;
			if(ocb < 0) return -1;
		}
		else return -1;
    }
    if(ocb > 0) return -1;
    else return 1;
}

int setcolor(int colornb)
{
    colornb %= (NOFC + 101);
    XSetForeground(display, canvasGC, color[colornb].pixel);
    XSetForeground(display, pmGC, color[colornb].pixel);
}

void DestroyResource()
{
    int i;

    XUnloadFont(display, font);
    XFreeGC(display, buttonGC);
    XFreeGC(display, hakGC);
    XFreeGC(display, canvasGC);
    XFreeGC(display, pmGC);
    XFreeGC(display, clearGC);
    for(i = 0; i < NUMOFSCN; i++) XFreePixmap(display, pixmap[i]);
    XDestroySubwindows(display, top);
    XDestroyWindow(display, top);
}

void ReDraw(event)
	 XExposeEvent *event;
{
    int i;

    for(i = 0; i < NUMOFBUTTON; i++) {
        if(event->window == buttons[i]) {
			XDrawString(display, buttons[i], buttonGC, 1, 23, 
						button_name[i], strlen(button_name[i]));
			return;
		}
    }
    if(event->window == canvas) {
	XCopyArea(display, pixmap[ddp], canvas, pmGC, event->x, event->y, event->width, event->height, event->x, event->y);
    }
}

void CreateResource()
{
    int x, i;
    Cursor cursor;

    top = XCreateSimpleWindow(display, DefaultRootWindow(display), 0, 0, TOP_WIDTH, TOP_HEIGHT, 2, 
			      BlackPixel(display, DefaultScreen(display)), 
			      WhitePixel(display, DefaultScreen(display)));
    XStoreName(display, top, "Graphic Drawing");
    x = 2;
    cursor = XCreateFontCursor(display, XC_coffee_mug);
    XDefineCursor(display, top, cursor);
    for(i = 0; i < NUMOFBUTTON; i++, x += 60) 
        buttons[i] = XCreateSimpleWindow(display, top, x, 2, BUTTON_WIDTH, BUTTON_HEIGHT, 2, 
			      BlackPixel(display, DefaultScreen(display)), 
			      WhitePixel(display, DefaultScreen(display)));
    hakw = XCreateSimpleWindow(display, top, CANVAS_WIDTH - HAK_WIDTH + 3, 2, HAK_WIDTH, HAK_HEIGHT, 2, BlackPixel(display, DefaultScreen(display)), WhitePixel(display, DefaultScreen(display)));
    cursor = XCreateFontCursor(display, XC_hand1);
    for(i = 0; i < NUMOFBUTTON; i++) XDefineCursor(display, buttons[i], cursor);
    canvas = XCreateSimpleWindow(display, top, 2, 34, CANVAS_WIDTH, CANVAS_HEIGHT, 2, 
			      BlackPixel(display, DefaultScreen(display)), 
			      WhitePixel(display, DefaultScreen(display)));

    XSelectInput(display, top, KeyPressMask);
    for(i = 0; i < NUMOFBUTTON; i++) XSelectInput(display, buttons[i], ExposureMask | ButtonPressMask);
    XSelectInput(display, canvas,  ExposureMask | ButtonPressMask);

    buttonGC = XCreateGC(display, top, 0, 0);
    XSetForeground(display, buttonGC, BlackPixel(display, DefaultScreen(display)));
    hakGC = XCreateGC(display, top, 0, 0);
    XSetForeground(display, hakGC, BlackPixel(display, DefaultScreen(display)));
    canvasGC = XCreateGC(display, canvas, 0, 0);
    XSetForeground(display, canvasGC, BlackPixel(display, DefaultScreen(display)));

    font = XLoadFont(display, "12x24");
    XSetFont(display, buttonGC, font);
    XSetFont(display, hakGC, font);
    font = XLoadFont(display, "8x16");
    XSetFont(display, canvasGC, font);

    XMapWindow(display, top);
    XMapSubwindows(display, top);

    for(i = 0; i < NUMOFSCN; i++) pixmap[i] = XCreatePixmap(display, canvas, CANVAS_WIDTH, CANVAS_HEIGHT, 
			   DefaultDepth(display, DefaultScreen(display)));
    clearGC = XCreateGC(display, canvas, 0, 0);
    XSetForeground(display, clearGC, WhitePixel(display, DefaultScreen(display)));
    for(i = 0; i < NUMOFSCN; i++) XFillRectangle(display, pixmap[i], clearGC, 0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
    pmGC = XCreateGC(display, canvas, 0, 0);
    XSetForeground(display, pmGC, BlackPixel(display, DefaultScreen(display)));
    XSetBackground(display, pmGC, WhitePixel(display, DefaultScreen(display)));
}

int HitKey(XEvent *event)
{
    char ch;
    KeySym keysym;

    XLookupString(&(event->xkey), &ch, 1, &keysym, NULL);
    switch(keysym) {
    case XK_F1:
    case XK_e:
    case XK_q: return END; break;
    }
    return EXEC;
}

int HitButton(XEvent *ev)
{
    int button;
	XButtonEvent *event;

	event = &(ev->xbutton);
    if(event->button == Button1) {
        for(button = 0; button < NUMOFBUTTON; button++) {
			if(event->window == buttons[button]) {
				if(button == 0) return END;
				return EXEC;
			}
		}
		if(event->window == canvas) {
			commandX = event->x;
			commandY = event->y;
		}
    }
    return EXEC;
}

void EventLoop()
{
    XEvent event;
    int drawg();

    XNextEvent(display, &event); ReDraw(&event);
    if(drawg() == 0) return;
    XDrawString(display, buttons[0], buttonGC, 1, 23, button_name[0], strlen(button_name[0]));
/*    Xflush(display);
*/
	for(;;) {
        XNextEvent(display, &event);
		switch(event.type)
			{
			case Expose: ReDraw(&event); break;
			case ButtonPress: if(HitButton(&event) == END) return; break;
			case KeyPress : if(HitKey(&event) == END) return; break;
			}
    }
}

int main(int argc, char *argv[])
{
    char *server, *ps;
    int i, dox = 0, doy = 0;
    unsigned short red, green, blue;

    CANVAS_WIDTH = 640, CANVAS_HEIGHT = 480;
    scale = SCALE;
	for(i = 1; i < argc; i++) {
		if(*(ps = argv[i]) != '-') continue;
		ps++;
		if(*ps == 'W' | *ps == 'w') {
			if(*(++ps) == '=') ps++;
			if((CANVAS_WIDTH = atoi(ps)) > MAX_CANVAS_WIDTH) CANVAS_WIDTH = MAX_CANVAS_WIDTH;
			continue;
		}
		if(*ps == 'H' | *ps == 'h') {
			if(*(++ps) == '=') ps++;
			if((CANVAS_HEIGHT = atoi(ps)) > MAX_CANVAS_HEIGHT) CANVAS_HEIGHT = MAX_CANVAS_HEIGHT;
			continue;
		}
		if(*ps == 'X' | *ps == 'x') {
			if(*(++ps) == '=') ps++;
			dox = atoi(ps);
			continue;
		}
		if(*ps == 'Y' | *ps == 'y') {
			if(*(++ps) == '=') ps++;
			doy = atoi(ps);
			continue;
		}
		if(*ps == 'S' | *ps == 's') {
			if(*(++ps) == '=') ps++;
			scale = atof(ps);
			continue;
		}
/*		if(*ps == 'C' | *ps == 'c') {
			codr = 1;
		}
*/
	}
    ox = CANVAS_WIDTH/2 + dox; oy = CANVAS_HEIGHT - CANVAS_HEIGHT/2 - doy;
    TOP_WIDTH = CANVAS_WIDTH + 8; TOP_HEIGHT = CANVAS_HEIGHT + 40;
    server = NULL;
    if((display = XOpenDisplay(server)) == NULL) exit(0);
    path = 0;
/*    else if((path=open(argv[1],O_RDONLY))== -1) exit(0);
*/
    cmap = DefaultColormap(display, DefaultScreen(display));
    for(i = 0, red = green = blue = CSTEP - 1; i < NOFC; i++) {
        color[i].red = red; color[i].green = green; color[i].blue = blue;
		XAllocColor(display, cmap, &color[i]);
		red += CSTEP;
		if(red < CSTEP) {
			green += CSTEP;
			if(green < CSTEP) {
				blue += CSTEP;
			}
		}
    }
    for(i = 0; i <= 100; i++) {
        color[NOFC + i].red = color[NOFC + i].green = color[NOFC + i].blue = 65535 * i / 100;
	XAllocColor(display, cmap, &color[NOFC + i]);
    }
/*    color[63].red = 201 * 256; color[63].green = 201 * 256; color[63].blue = 201 * 256;
    if(XAllocColor(display, cmap, &color[63]) == False) {
        printf("False\n");
	XCloseDisplay(display);
	exit(0);
    }
*/
    CreateResource();
    EventLoop();
    DestroyResource();
    XCloseDisplay(display);
    if(path>0) close(path);
}

int drawg()
{
    int x, y, colornb;
    int x2, y2, pcolor, bcolor;
    double cx, cy, c0;
    extern char *grcmds[];
    int i, a[MXNOFWD], l;
    char s[MXSTRLH];
    XEvent event;

    adp = ddp = 0;
    setcolor(colornb = 0);
    while(getl(s) >= 2) {
        l = cut(s, a);
        for(i = 0; i < NUMOFCMDS; i++) if(cmpword(s, grcmds[i]) == 0) break;
        if(i == 7) break;
		if(i == NUMOFCMDS - 1) return 0;
        switch(i) {
            case 0: if(l > 3) colornb = atoi(s + a[1]) + 4 * (atoi(s + a[2]) + 4 * atoi(s + a[3]));
	            else if(l>1) colornb = atoi(s + a[1]);
                    setcolor(colornb);
                    break;
            case 1: if(l > 2){
	      /*
                        x = ox + (int)(scale * atof(s+a[1]));
                        y = oy - (int)(scale * atof(s+a[2]));
                        if(ddp == adp) XDrawPoint(display, canvas, canvasGC, x, y);
                        XDrawPoint(display, pixmap[adp], canvasGC, x, y);
	      */
                        int count = l/2, j;
                        if(count > MNP) count = MNP;
			for(j = 0; j < count; j++) {
			    points[j].x = ox + (int)(scale * atof(s+a[2 * j + 1]));
			    points[j].y = oy - (int)(scale * atof(s+a[2 * j + 2]));
			}
                        if(ddp == adp) XDrawPoints(display, canvas, canvasGC, points, count, CoordModeOrigin);
                        XDrawPoints(display, pixmap[adp], canvasGC, points, count, CoordModeOrigin);
                    }
                    break;
            case 2: if(l > 3){
		        double lx = - (double) ox / scale,
					ux = (double) (CANVAS_WIDTH - ox) / scale,
					ly = - (double) (CANVAS_HEIGHT - oy) / scale,
					uy = (double) oy / scale, t, t2;
				cx = atof(s+a[1]);
				cy = atof(s+a[2]);
				c0 = atof(s+a[3]);
			if(cx == .0) {
			    if(cy == .0) break;
			    if((t = -c0/cy) < uy && t > ly) {
				x = ox + (int)(scale * lx);
				y = y2 = oy - (int)(scale * t);
				x2 = ox + (int)(scale * ux);
			        if(ddp == adp) XDrawLine(display, canvas, canvasGC, x, y, x2, y2);
			        XDrawLine(display, pixmap[adp], canvasGC, x, y, x2, y2);
				break;
			    }
			}
			if(cy == .0) {
			    if((t = -c0/cx) < ux && t > lx) {
				x = x2 = ox + (int)(scale * t);
				y = oy - (int)(scale * ly);
				y2 = oy - (int)(scale * uy);
                                if(ddp == adp) XDrawLine(display, canvas, canvasGC, x, y, x2, y2);
                                XDrawLine(display, pixmap[adp], canvasGC, x, y, x2, y2);
				break;
			    }
			}
			if((t = -(cx * lx + c0)/cy) < ly) {
			    if(cy/cx >= .0) break;
			    if((t2 = -(cy * ly + c0)/cx) > ux) break;
			    x = ox + (int)(scale * t2); y = oy - (int)(scale * ly);
			}
			else if(t <= uy) {
			    x = ox + (int)(scale * lx); y = oy - (int)(scale * t);
			}
			else {
			    if(cy/cx <= .0) break;
			    if((t2 = -(cy * uy + c0)/cx) > ux) break;
			    x = ox + (int)(scale * t2); y = oy - (int)(scale * uy);
			}
			if((t = -(cx * ux + c0)/cy) < ly) {
			    x2 = ox + (int)(-scale * (cy * ly + c0)/cx); y2 = oy - (int)(scale * ly);
			}
			else if(t <= uy) {
			    x2 = ox + (int)(scale * ux); y2 = oy - (int)(scale * t);
			}
			else {
			    x2 = ox + (int)(-scale * (cy * uy + c0)/cx); y2 = oy - (int)(scale * uy);
			}
                        if(ddp == adp) XDrawLine(display, canvas, canvasGC, x, y, x2, y2);
                        XDrawLine(display, pixmap[adp], canvasGC, x, y, x2, y2);
                    }
                    break;
            case 3: if(l>3) {
		        int ag1 = 0, ag2 = 360;
                        x = ox + scale * atof(s + a[1]); y = oy - scale * atof(s + a[2]);
	                x2 = scale * atof(s + a[3]);
        	        if(l > 4) y2 = scale * atof(s + a[4]);
                	else y2 = x2;
					if(l > 6) {
						ag1 = 180 * atof(s + a[5]) / M_PI;
						ag2 = 180 * atof(s + a[6]) / M_PI;
					}
                          if(ddp == adp) XDrawArc(display, canvas, canvasGC, x - x2, y - y2, 2 * x2, 2 * y2, 64 * ag1, 64 * ag2);
                          XDrawArc(display, pixmap[adp], canvasGC, x - x2, y - y2, 2 * x2, 2 * y2, 64 * ag1, 64 * ag2);
                    }
                    break;
            case 4: if(l > 6){
                        int count, j;
                        count = l/2;
                        if(count > MNP) count = MNP;
                        for(j = 0 ;j < count; j++) {
                            points[j].x = ox + scale * atof(s + a[2 * j + 1]); points[j].y = oy - scale * atof(s + a[2 * j + 2]);
			}
			XSetFillRule(display, canvasGC, EvenOddRule);
			if(ddp == adp) XFillPolygon(display, canvas, canvasGC, points, count, Complex, CoordModeOrigin);
			XFillPolygon(display, pixmap[adp], canvasGC, points, count, Complex, CoordModeOrigin);
					}
				break;
		case 5: if(l > 1) {
		        int dd;
			if(checkeq(s + a[1]) < 1) {
			    XDrawString(display, canvas, canvasGC, 1, 23, "Parameter of curve must be a polynomial of x and y", 50);
			}
			else if((dd = expand(s + a[1], c)) > 1){
			    grdt(dd, c);
			}
			else if(dd == -1) {
			    XDrawString(display, canvas, canvasGC, 1, 23, "Parameter of curve must be a polynomial", 39);
			}
		    }
	            break;
            case 6: if(l > 3) {
		        int ag1 = 0, ag2 = 64 * 360;
                          x = ox + (int)(scale * atof(s + a[1]));
			  y = oy - (int)(scale * atof(s + a[2]));
                          x2 = (int)(scale * atof(s + a[3]));
			if(l > 5) {
			    ag1 = atoi(s + a[4]);
			    ag2 = atoi(s + a[5]);
			}
                          if(adp == ddp) XDrawArc(display, canvas, canvasGC, x - x2, y - x2, 2 * x2, 2 * x2, ag1, ag2);
                          XDrawArc(display, pixmap[adp], canvasGC, x - x2, y - x2, 2 * x2, 2 * x2, ag1, ag2);
                      }
                      break;
	    case 8: if(l > 1) {
						  x = atoi(s + a[1]);
						  XSync(display, False);
						  for( ; x > 0; x--) {
							  sprintf(sleep_str, "%d seconds", x);
							  XDrawString(display, hakw, hakGC, 1, 23, sleep_str, 10);
							  XFlush(display);
							  sleep(1);
							  XFillRectangle(display, hakw, clearGC, 0, 0, HAK_WIDTH, HAK_HEIGHT);
						  }
					  }
	              break;
	    case 9: if(l > 2) {
		          if((x = atoi(s + a[1])) > NUMOFSCN - 1 || x < 0 || (y = atoi(s + a[2])) > NUMOFSCN - 1 || y < 0) break;
		          if(ddp == y) XCopyArea(display, pixmap[x], canvas, pmGC, 0, 0, CANVAS_WIDTH, CANVAS_HEIGHT, 0, 0);
		          XCopyArea(display, pixmap[x], pixmap[y], pmGC, 0, 0, CANVAS_WIDTH, CANVAS_HEIGHT, 0, 0);
	            }
	            break;
	    case 10: if(l > 4){
                        int count = l/2, j;
                        if(count > MNP) count = MNP;
                        for(j = 0 ;j < count; j++) {
                            points[j].x = ox + (int)(scale * atof(s + a[2 * j + 1])); points[j].y = oy - (int)(scale * atof(s + a[2 * j + 2]));
			}
			/*
                        x = ox + (int)(scale * atof(s + a[1]));
                        y = oy - (int)(scale * atof(s + a[2]));
                        x2 = ox + (int)(scale * atof(s + a[3]));
                        y2 = oy - (int)(scale * atof(s + a[4]));
                        if(adp == ddp) XDrawLine(display, canvas, canvasGC, x, y, x2, y2);
                        XDrawLine(display, pixmap[adp], canvasGC, x, y, x2, y2);
			*/
                        if(adp == ddp) XDrawLines(display, canvas, canvasGC, points, count, CoordModeOrigin);
                        XDrawLines(display, pixmap[adp], canvasGC, points, count, CoordModeOrigin);
		    }
	            break;
	    case 11: if(l > 1) {
		        if((x = atoi(s + a[1])) > NUMOFSCN - 1 || x < 0) break;
			adp = x;
		    }
	            break;
	    case 12: if(l > 1) {
		        if((x = atoi(s + a[1])) > NUMOFSCN - 1 || x < 0) break;
			ddp = x;
			XCopyArea(display, pixmap[ddp], canvas, pmGC, 0, 0, CANVAS_WIDTH, CANVAS_HEIGHT, 0, 0);
		    }
	            break;
	    case 13:
	            if(ddp == adp) XFillRectangle(display, canvas, clearGC, 0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
	            XFillRectangle(display, pixmap[adp], clearGC, 0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
	            break;
	    case 14: if(l > 3) {
		         for(i = 4; i < l; i++) *(s + a[i] - 1) = ' ';
		         XDrawString(display, canvas, canvasGC, ox + (int)(scale * atof(s + a[1])), oy - (int)(scale * atof(s + a[2])), s + a[3], strlen(s + a[3]));
		         XDrawString(display, pixmap[adp], canvasGC, ox + (int)(scale * atof(s + a[1])), oy - (int)(scale * atof(s + a[2])), s + a[3], strlen(s + a[3]));
	            }
	            break;
	    case 15:
            case 16: if(l > 3) {
                          x = ox + (int)(scale * atof(s + a[1]));
			  y = oy - (int)(scale * atof(s + a[2]));
                          if(i == 15) x2 = (int)(scale * atof(s + a[3]));
			  else x2 = (int)(atof(s + a[3]));
                          if(adp == ddp) XFillArc(display, canvas, canvasGC, x - x2, y - x2, 2 * x2, 2 * x2, 0, 64 * 360);
                          XFillArc(display, pixmap[adp], canvasGC, x - x2, y - x2, 2 * x2, 2 * x2, 0, 64 * 360);
                     }
                     break;
            case 17: for( ; ; ) {
                          XDrawString(display, hakw, hakGC, 1, 23, hak_st, 11);
	                  XNextEvent(display, &event);
			  XFillRectangle(display, hakw, clearGC, 0, 0, HAK_WIDTH, HAK_HEIGHT);
			  /*
                          XDrawString(display, hakw, hakGC, 1, 23, "           ", 11);
			  */
			  if(event.type == KeyPress) break;
                     }
                     break;
	    case 18: if(l > 3) {
		         for(i = 4; i < l; i++) *(s + a[i] - 1) = ' ';
		         XDrawString(display, canvas, canvasGC, atoi(s + a[1]), atoi(s + a[2]), s + a[3], strlen(s + a[3]));
		         XDrawString(display, pixmap[adp], canvasGC, atoi(s + a[1]), atoi(s + a[2]), s + a[3], strlen(s + a[3]));
	            }
	            break;
	    case 19: if(l > 1) {
                    setcolor(NOFC + (int)(100 * atof(s + a[1])));
	            }
	            break;
	    case 20: XSync(display, False);
	            break;
	    case 21: XFlush(display); usleep(atoi(s + a[1]) * 10000);
	            break;
            default: break;
        }
/*	XCopyArea(display, pixmap[ddp], canvas, pmGC, 0, 0, CANVAS_WIDTH, CANVAS_HEIGHT, 0, 0);
*/
	
    }
    return 1;
}

void grdt(int dg, double a[])
{
	int ix, iy, i, j, k, n, top;
	double c[MAXD];

	top = (dg + 1) * (dg + 2) / 2 - 1;
	for(ix = -ox; ix < CANVAS_WIDTH - ox; ix++) {
		for(x[0] = 1., x[1] = (double)ix * 1./scale, i = 2; i <= dg; i++) x[i] = x[i - 1] * x[1];
		for(i = 0; i <= dg; i++) {
			for(c[dg - i] = 0., j = i, k = dg + 1; k > i; j += k--) c[dg - i] += a[top - j] * x[k - i - 1];
		}
/*		printf("%d: ", ix);
		for(i = 0; i <= dg; i++) printf("%f ", c[i]);
		printf("\n");
*/		n = fdallsol(dg, c, z);
		for(i = 0; i < n; i++) {
/*		    printf("point %d %d\n", ox + ix, oy - (int)(z[i] * scale));
*/		    if(adp == ddp) XDrawPoint(display, canvas, canvasGC, ox + ix, oy - (int)(z[i] * scale));

		    XDrawPoint(display, pixmap[adp], canvasGC, ox + ix, oy - (int)(z[i] * scale));
		}

	}
	for(iy = oy - CANVAS_HEIGHT; iy < oy; iy++) {
		for(x[0] = 1., x[1] = (double)iy * 1./scale, i = 2; i <= dg; i++) x[i] = x[i - 1] * x[1];
		for(i = 0; i <= dg; i++) {
			for(c[dg - i] = 0., j = dg - i, k = dg; k >= i; j += k--) c[dg - i] += a[top - j] * x[k - i];
		}
/*		printf("%d: ", iy);
		for(i = 0; i <= dg; i++) printf("%f ", c[i]);
		printf("\n");
*/		n = fdallsol(dg, c, z);
		for(i = 0; i < n; i++) {
/*		    printf("point %d %d\n", ox + (int)(z[i] * scale), oy - iy);
*/		    if(adp == ddp) XDrawPoint(display, canvas, canvasGC, ox + (int)(z[i] * scale), oy - iy);

		    XDrawPoint(display, pixmap[adp], canvasGC, ox + (int)(z[i] * scale), oy - iy);
		}

	}
}
