#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int main(int argc, char *argv[])
{
    int n = 2, adp = 1;
    double t, dt = .01, x, y, x0 = 1., y0 = 0., r;

    if(argc > 1) n = atoi(argv[1]);
    r = 1./(double) n;
    printf("color 0 0 0\ncircle 0 0 1\n");
    for(t = 0.; t < 3.14; t += r * 3.14/3.) {
		printf("connect %f %f %f %f\n", x = cos(t), y = sin(t), -cos(t), -sin(t));
    }
    printf("display %d", adp);
    for(t = dt; t < 6.28; t += dt) {
		x = (1. + r) * cos(t) + r * cos(3.14 + (n + 1) * t);
		y = (1. + r) * sin(t) + r * sin(3.14 + (n + 1) * t);
		printf("active 0\ncolor 3 0 0\nconnect %f %f %f %f\n", x, y, x0, y0);
		if(adp == 1) adp = 2;
		else adp = 1;
		printf("copy 0 %d\nactive %d\n", adp, adp);
		printf("color 0 0 3\ncircle %f %f %f\n", (1. + r) * cos(t), (1. + r) * sin(t), r);
		printf("color 0 2 2\nconnect %f %f %f %f\n", x, y, (1. + r) * cos(t) - r * cos(3.14 + (n + 1) * t), (1. + r) * sin(t) - r * sin(3.14 + (n + 1) * t));
		printf("color 2 2 0\nconnect %f %f %f %f\n", (1. + r) * cos(t) + r * cos(4 * 3.14/3. + (n + 1) * t), (1. + r) * sin(t) + r * sin(4 * 3.14/3. + (n + 1) * t), (1. + r) * cos(t) - r * cos(4 * 3.14/3. + (n + 1) * t), (1. + r) * sin(t) - r * sin(4 * 3.14/3. + (n + 1) * t));
		printf("color 2 0 2\nconnect %f %f %f %f\n", (1. + r) * cos(t) + r * cos(5 * 3.14/3. + (n + 1) * t), (1. + r) * sin(t) + r * sin(5 * 3.14/3. + (n + 1) * t), (1. + r) * cos(t) - r * cos(5 * 3.14/3. + (n + 1) * t), (1. + r) * sin(t) - r * sin(5 * 3.14/3. + (n + 1) * t));
		printf("display %d\ntsleep 3\n", adp);
		x0 = x; y0 = y;
    }
    return 0;
}
