/*
f(x, y, z) = 0 ɽ̤ z 鸫
f(x, y, z) = f_0(x, z)y^d + ... + f_d-1(x, z)y + f_d(x, z) 
ΤȤ c[i]  f_i(x, z) ,
ؿ fdallsol(d, c, yy) Ƥ֤Ȥΰ d  f  y ˴ؤ뼡Ȥ
f(x, y, z) = f_0(y, z)x^d + ... + f_d-1(y, z)x + f_d(y, z) 
ΤȤ c[i]  f_i(y, z) ,
ؿ fdallsol(d, c, xx) Ƥ֤Ȥΰ d  f  x ˴ؤ뼡Ȥ
ؿ dzdx  dz/dx ֤ͤ褦
ؿ dzdy  dz/dy ֤ͤ褦
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define step .003
#define gosa .0000001
#define MAXD 10

double cc[MAXD], zz[MAXD], yy[MAXD];
static double xx[MAXD];

double solvae(int degree, double cc[], double x0);
int fdallsol(int degree, double c[], double z[]);

double dzdx(double x, double y, double z)
{
    double x2 = x * x, z2 = z * z;

    return -(2.5 * x * x2 + 2.598 * x2 * z + (4.5 * z2 - 2.) * x - .866 * z2 * z) / (2.5 * z * z2 - 2.598 * x * z2 + (4.5 * x2 - 2.) * z + .866 * x2 * x);
}

double dzdy(double x, double y, double z)
{
    double x2 = x * x, z2 = z * z;

    return -2. * y / (2.5 * z * z2 - 2.598 * x * z2 + (4.5 * x2 - 2.) * z + .866 * x2 * x);
}

int main()
{
    int j, i, n;
    double x, y, z, x0, y0, z0, x2, y2, z2, x4, z4, gray, a, b, c;

    a = .1; b = .2; c = sqrt(1. - a * a - b * b);
    /*
    printf("gray .5\n");
    for(x = -1.4; x <= 1.4; x += .2) printf("connect %f -.8 %f .8\n", x, x);
    for(y = -.8; y <= .8; y += .2) printf("connect -1.4 %f 1.4 %f\n", y, y);
    */
    printf("gray 0.\nconnect -1.6 0. 1.6 0.\nconnect 0. -1. 0. 1.\ntext 1.4 0.01 .5x+.866y\ntext 0.01 1. z\n");
    printf("gray 0.\nText 0 20 x^4 + y^4 - x^2 - y^2 + z^2 = 0\n");
    for(z = -1.4; z < 1.4; z += step * 3.) {
        /*
        printf("gray 0.\nText 0 50 %.2f\n", z);
        */
        z2 = z * z; z4 = z2 * z2;
	for(y = -.8; y < .8; y += step) {
	    y2 = y * y;
	    cc[0] = .625; cc[1] = .866 * z; cc[2] = 2.25 * z2 - 1.; cc[3] = -.866 * z2 * z;
	    cc[4] = .625 * z4 - z2 + y2;
	    n = fdallsol(4, cc, xx);
	    for(i = 0; i < n; i++) {
	        x = xx[i];
		x0 = dzdx(x, y, z); y0 = dzdy(x, y, z);
		if((gray = (-a * x0 - b * y0 + c) / sqrt(1. + x0 * x0 + y0 * y0)) < .0) gray = 0.;
		printf("gray %f\npoint %f %f\n", gray, x, y);
	    }
	}
	for(x = -1.4; x < 1.4; x += step) {
	  x2 = x * x; x4 = x2 * x2;
	    cc[0] = 1.; cc[1] = 0.; 
	    cc[2] = x2 * (.625 * x2 + .866 * x * z + 2.25 * z2 - 1.) + z2 * (-.866 * x * z + .625 * z2 - 1.);
	    n = fdallsol(2, cc, yy);
	    for(i = 0; i < n; i++) {
	        y = yy[i];
		x0 = dzdx(x, y, z); y0 = dzdy(x, y, z);
		if((gray = (-a * x0 - b * y0 + c) / sqrt(1. + x0 * x0 + y0 * y0)) < .0) gray = 0.;
		printf("gray %f\npoint %f %f\n", gray, x, y);
	    }
	}
    }
    return 0;
}
