/*
f(x, y, z) = 0 ɽ̤ z 鸫
f(x, y, z) = f_0(x, y)z^d + ... + f_d-1(x, y)z + f_d(x, y) 
ΤȤؿ ft()  c[i]  f_i(x, y) ,
ؿ fdallsol(d, c, zz) Ƥ֤Ȥΰ d  f  z ˴ؤ뼡Ȥ
ؿ dzdx  dz/dx ֤ͤ褦
ؿ dzdy  dz/dy ֤ͤ褦
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define step .003
#define gosa .0000001
#define MAXD 10
#define MINZ -10001.
#define SVPT 100

double c[MAXD], zz[MAXD];
int np[101];
struct PT {
  double x, y;
} points[101 * SVPT];

double solvae(int degree, double c[], double x0);
int fdallsol(int degree, double c[], double z[]);

double ft(double x, double y)
{
    int i, n;
    double x2 = x * x, x4 = x2 * x2, y2 = y * y, z;

    c[0] = .625; c[1] = -.866 * x; c[2] = 2.25 * x2 - 1.; c[3] = .866 * x2 * x;
    c[4] = .625 * x4 - x2 + y2;
    if((n = fdallsol(4, c, zz)) == 0) return MINZ;
    for(z = MINZ, i = 0; i < n; i++) if(zz[i] < .3 * x + 1. * y + 1. && z < zz[i]) z = zz[i];
    return z;
}

double dzdx(double x, double y, double z)
{
    double x2 = x * x, z2 = z * z;

    return -(2.5 * x * x2 + 2.598 * x2 * z + (4.5 * z2 - 2.) * x - .866 * z2 * z) / (2.5 * z * z2 - 2.598 * x * z2 + (4.5 * x2 - 2.) * z + .866 * x2 * x);
}

double dzdy(double x, double y, double z)
{
    double x2 = x * x, z2 = z * z;

    return -2. * y / (2.5 * z * z2 - 2.598 * x * z2 + (4.5 * x2 - 2.) * z + .866 * x2 * x);
}

int main()
{
    int j, ig;
    double x, y, z, x0, y0, z0, gray, a, b, c, z2;

    for(j = 0; j < 101; j++) np[j] = 0;
    a = .1; b = .2; c = sqrt(1. - a * a - b * b);
    /*
    printf("color 0 3 3\npolygon -1.2 -1.1 -1.2 1.1 1.2 1.1 1.2 -1.1\n");
    */
    printf("gray .5\n");
    for(x = -1.4; x <= 1.4; x += .2) printf("connect %f -.8 %f .8\n", x, x);
    for(y = -.8; y <= .8; y += .2) printf("connect -1.4 %f 1.4 %f\n", y, y);
    printf("gray 0.\nconnect -1.6 0. 1.6 0.\nconnect 0. -1. 0. 1.\ntext 1.4 0.01 .5x+.866y\ntext 0.01 1. z\n");
    printf("gray 0.\nText 0 20 x^4 + y^4 - x^2 - y^2 + z^2 = 0\n");
    for(x = -1.4; x < 1.4; x += step) {
	for(y = -.8; y < .8; y += step) {
	    if((z = ft(x, y)) < MINZ + 1) continue;
	    x0 = dzdx(x, y, z); y0 = dzdy(x, y, z);
	    if((gray = (-a * x0 - b * y0 + c) / sqrt(1. + x0 * x0 + y0 * y0)) < .0) gray = 0.;
	    ig = gray * 100;
	    points[ig * SVPT + np[ig]].x = x;
	    points[ig * SVPT + np[ig]].y = y;
	    np[ig]++;
	    if(np[ig] == SVPT) {
	        printf("gray %f\npoint", gray);
		for(j = 0; j < SVPT; j++) printf(" %f %f", points[ig * SVPT + j].x, points[ig * SVPT + j].y);
		printf("\n");
		np[ig] = 0;
	    }
	    /*
	    printf("gray %f\npoint %f %f\n", gray, x, y);
	    */
	}
    }
    for(ig = 0; ig <= 100; ig++) {
        printf("gray %f\npoint", ig * .01);
	for(j = 0; j < np[ig]; j++) printf(" %f %f", points[ig * SVPT + j].x, points[ig * SVPT + j].y);
	printf("\n");
    }
    return 0;
}
