/* z^2 = f(x, y) ɽ̤夫鸫 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define step .003
#define SVPT 100

int np[101];
struct PT {
  double x, y;
} points[101 * SVPT];

double ft(double x, double y)
{
    double x2 = x * x, y2 = y * y;

    return  x2 * (1. - x2) +  y2 * (1. -  y2);
}

double fx(double x, double y)
{
    double x2 = x * x;

    return 2. * x * (1. - 2. * x2);
}

double fy(double x, double y)
{
    double y2 = y * y;

    return 2. * y * (1. - 2. * y2);
}

int main()
{
    int j, ig;
    double x, y, z, x0, y0, z0, gray, a, b, c;

    for(j = 0; j < 101; j++) np[j] = 0;
    a = .1; b = .2; c = sqrt(1. - a * a - b * b);
    printf("color 0 3 3\npolygon -1.3 -1.2 -1.3 1.2 1.3 1.2 1.3 -1.2\n");
    printf("color 0 0 0\nText 0 20 z^2 = x^2 + y^2 - x^4 - y^4\n");
    for(x = -1.5; x < 1.5; x += step) {
	for(y = -1.5; y < 1.5; y += step) {
	    if((z = ft(x, y)) <= 0.) continue;
	    z = sqrt(z);
	    x0 = .5 * fx(x, y) / z; y0 = .5 * fy(x, y) / z;
	    if((gray = (-a * x0 - b * y0 + c) / sqrt(1. + x0 * x0 + y0 * y0)) < .0) gray = 0.;
	    ig = gray * 100;
	    points[ig * SVPT + np[ig]].x = x;
	    points[ig * SVPT + np[ig]].y = y;
	    np[ig]++;
	    if(np[ig] == SVPT) {
	        printf("gray %f\npoint", gray);
		for(j = 0; j < SVPT; j++) printf(" %f %f", points[ig * SVPT + j].x, points[ig * SVPT + j].y);
		printf("\n");
		np[ig] = 0;
	    }
	    /*
	    printf("gray %f\npoint %f %f\n", gray, x, y);
	    */
	}
    }
    for(ig = 0; ig <= 100; ig++) {
        printf("gray %f\npoint", ig * .01);
	for(j = 0; j < np[ig]; j++) printf(" %f %f", points[ig * SVPT + j].x, points[ig * SVPT + j].y);
	printf("\n");
    }
    return 0;
}
