#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct Pline {
    double a, b, c;
} Pl;

double operator |(Pl p, Pl q)
{
    return p.a * q.a + p.b * q.b - 4. * p.c * q.c;
}


void WRITE(Pl p)
{
    double d = p | p, a2b2 = p.a * p.a + p.b * p.b, c2 = p.c * p.c;

    if(d > 0) {
        double s, t, r;

		if(c2 < a2b2 * .00001) {
			double d = sqrt(a2b2), x0 = p.b / d, y0 = -p.a / d;

			printf("connect %f %f %f %f\n", x0, y0, -x0, -y0);
		}
		else {
			if(p.c > 0) {
				r = .5 * sqrt(d) / p.c;
				t = atan2(p.b, p.a);
			}
			else {
				r = -.5 * sqrt(d) / p.c;
				if((t = atan2(p.b, p.a)) < 0) t += M_PI;
				else t -= M_PI;
			}
			s = atan2(1., r);
			printf("circle %f %f %f %f %f\n", -.5 * p.a / p.c, -.5 * p.b / p.c, r, (t - s) * 64. * 180. / M_PI, s * 128. * 180. / M_PI);
		}
    }
    else {
        double r;

		if(a2b2 < c2 * .000001) printf("disk 0. 0. .02\n");
		else {
			if(p.c > 0) r = -2. * p.c + sqrt(-d);
			else r = -2. * p.c - sqrt(-d);
			r /= a2b2;
			printf("disk %f %f .02\n", p.a * r, p.b * r);
		}
    }
}

Pl operator *(Pl p, Pl q)
{
    Pl r;

    r.a = 4. * (p.b * q.c - p.c * q.b);
    r.b = 4. * (p.c * q.a - p.a * q.c);
    r.c = p.b * q.a - p.a * q.b;
    return r;
}

int main()
{
    Pl a, b, c, ab, bc, ca, abc, bca, cab, l, la, lb, r;
	int adp = 1;

	a.a = bc.a = 1.; a.b = 3.; a.c = bc.c = 1;
	bc.b = -a.b;
	r.a = -0.5; r.b = 0.; r.c = 1.;
	b = bc * r;
	ab = a * b;
	c.a = ab.a; c.b = -ab.b; c.c = ab.c;
	ca.a = b.a; ca.b = -b.b; ca.c = b.c;
	printf("gray .6\ncircle 0 0 1\ngray 0\n");
	WRITE(a); WRITE(b); WRITE(c);
	printf("gray 0.8\n");
	WRITE(ab); WRITE(bc); WRITE(ca);
	l.a = l.c = 0.; l.b = 1.;
	printf("color 0 0 3\n");
	WRITE(l);
	printf("copy 0 %d\nactive %d\n", adp, adp);
	printf("color 3 0 0\n");
	l.a = 2.;
	l.b = 0.; l.c = 1.;
	WRITE(la = l * a); WRITE(lb = l * b); WRITE(l * c);
	WRITE((la * a) * (lb * b));
	printf("display %d\npause\n", adp);
	adp = 2;
	for(;l.a > -2.; ) {
		if(l.a > 1.5) l.a -= 0.001;
		else if(l.a > -1.5) l.a -= 0.002;
		else l.a -= 0.001;
		printf("copy 0 %d\nactive %d\n", adp, adp);
		WRITE(la = l * a); WRITE(lb = l * b); WRITE(l * c);
		WRITE((la * a) * (lb * b));
		printf("display %d\ntsleep 2\n", adp);
		if(adp == 1) adp = 2;
		else adp = 1;
	}
	return 0;
}
