#include <math.h>
#include "planegeometry.h"

int main(int argc, char *argv[])
{
	int i, adp = 1;
	double t, x0, y0, x1, y1, ct, st, xy;
	POINT A[3], P, Q[3];
	LINE l, m[3];

	if(argc < 4) {
		A[0].x = cos(0.1); A[0].y = sin(0.1);
		A[1].x = cos(1.5); A[1].y = sin(1.5);
		A[2].x = cos(3.2); A[2].y = sin(3.2);
	}
	else {
		for(i = 0; i < 3; i++) {
			t = atof(argv[i+1]);
			A[i].x = cos(t);
			A[i].y = sin(t);
		}
	}
	printf("gray 0.5\ncircle 0 0 1\ngray 0.7\n");
	WRITE(m[0] = A[0] * A[1]);
	WRITE(m[1] = A[1] * A[2]);
	WRITE(m[2] = A[2] * A[0]);
	printf("gray 0\n");
	WRITE(A[0], A[1]); WRITE(A[1], A[2]); WRITE(A[2], A[0]);
	x0 = y0 = 1.;
	printf("color 3 1 0\n");
	for(t = 0.003; t < 2 * M_PI; t += 0.003) {
		P.x = cos(t);
		P.y = sin(t);
		l = ((P | m[0]) * m[0]) * ((P | m[1]) * m[1]);
		x1 = -l.a / l.c; y1 = -l.b / l.c;
		xy = x0 * y1 - x1 * y0;
		printf("point %f %f\n", (y1 - y0) / xy, (x0 - x1) / xy);
		x0 = x1; y0 = y1;
	}
	P.x = 1.; P.y = 0.;
	printf("copy 0 1\nactive 1\n");
	printf("color 0 0 3\n");
	for(i = 0; i < 3; i++) WRITE(P, Q[i] = (P | m[i]) * m[i]);
	printf("color 3 0 0\n");
	WRITE(l = Q[0] * Q[1]);
	printf("display 1\npause\n");
	for(t = 0.1; t < 2 * M_PI; t += 0.03) {
		printf("copy 0 %d\nactive %d\n", adp, adp);
		P.x = cos(t);
		P.y = sin(t);
		printf("color 0 0 3\n");
		for(i = 0; i < 3; i++) WRITE(P, Q[i] = (P | m[i]) * m[i]);
		printf("color 3 0 0\n");
		WRITE(l = Q[0] * Q[1]);
		printf("display %d\ntsleep 20\n", adp);
		if(adp == 1) adp = 2;
		else adp = 1;
	}
	return 0;
}
